(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 7.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    448442,       7982]
NotebookOptionsPosition[    444699,       7851]
NotebookOutlinePosition[    445044,       7866]
CellTagsIndexPosition[    445001,       7863]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["\<\
Calculate the trajectory of a radially - directed ion through the magnet\
\>", "Title",
 CellChangeTimes->{{3.56573022689174*^9, 3.565730271383018*^9}}],

Cell[CellGroupData[{

Cell["Normalized B-field models", "Section",
 CellChangeTimes->{{3.5657303399763384`*^9, 3.565730363173579*^9}, 
   3.5657306345828557`*^9}],

Cell[CellGroupData[{

Cell["\<\
Constant field with radius given by a multiple of pole-piece radius\
\>", "Subsection",
 CellChangeTimes->{{3.565730400722845*^9, 3.5657304347309046`*^9}}],

Cell[BoxData[{
 RowBox[{"Clear", "[", "Bconstant", "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Bconstant", "[", "R_", "]"}], ":=", 
  RowBox[{"Function", "[", 
   RowBox[{
    RowBox[{"{", "r", "}"}], ",", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"r", ">", "R"}], ",", "0.0", ",", "1.0"}], "]"}]}], 
   "]"}]}]}], "Input",
 CellChangeTimes->{{3.5657304893154006`*^9, 3.565730613678819*^9}, {
  3.565732521920971*^9, 3.565732529970585*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Field given by R. Gomez in MASS2.BAS (circa 1985)\
\>", "Subsection",
 CellChangeTimes->{{3.565730400722845*^9, 3.5657304347309046`*^9}, {
  3.565892889473548*^9, 3.5658929350851564`*^9}}],

Cell[BoxData[{
 RowBox[{"Clear", "[", "Bmass2", "]"}], "\[IndentingNewLine]", 
 RowBox[{"Bmass2", ":=", 
  RowBox[{"Function", "[", 
   RowBox[{
    RowBox[{"{", "R", "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{"Block", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"r", "=", " ", 
         RowBox[{"R", " ", "\[Times]", "2.5", " ", "2.54"}]}], " ", 
        RowBox[{"(*", " ", "cm", " ", "*)"}], ",", " ", "RG"}], "}"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"RG", "=", 
        RowBox[{
         RowBox[{"-", "32.05"}], "+", 
         RowBox[{"6.62", "r"}]}]}], ";", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"Piecewise", "[", 
         RowBox[{"{", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"20.", ",", 
             RowBox[{"RG", "<", "0"}]}], "}"}], ",", "\[IndentingNewLine]", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"20.", "-", 
              RowBox[{".03", "RG"}]}], ",", 
             RowBox[{"RG", "<", "5"}]}], "}"}], ",", "\[IndentingNewLine]", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"16.13", "+", 
              RowBox[{"1.388", "RG"}], "-", 
              RowBox[{".1328", 
               RowBox[{"RG", "^", "2"}]}]}], ",", 
             RowBox[{"RG", "<", "14"}]}], "}"}], ",", "\[IndentingNewLine]", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"37.48", "-", 
              RowBox[{"2.74", "RG"}], "+", 
              RowBox[{".05564", 
               RowBox[{"RG", "^", "2"}]}]}], ",", 
             RowBox[{"RG", "<", "24"}]}], "}"}], ",", "\[IndentingNewLine]", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"12.57", "-", 
              RowBox[{".5098001", "RG"}], "+", 
              RowBox[{".005895", 
               RowBox[{"RG", "^", "2"}]}]}], ",", 
             RowBox[{"RG", "<", "41"}]}], "}"}], ",", "\[IndentingNewLine]", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"4.966", "-", 
              RowBox[{".1139", "RG"}], "+", 
              RowBox[{".00071", 
               RowBox[{"RG", "^", "2"}]}]}], ",", 
             RowBox[{"RG", "<", "72"}]}], "}"}]}], "\[IndentingNewLine]", 
          "}"}], "]"}], "/", "20."}]}]}], "\[IndentingNewLine]", "]"}]}], 
   "\[IndentingNewLine]", "]"}]}]}], "Input",
 CellChangeTimes->{{3.5657304893154006`*^9, 3.565730613678819*^9}, {
  3.565732521920971*^9, 3.565732529970585*^9}, {3.5658929456607614`*^9, 
  3.565892974403405*^9}, {3.5658930182839155`*^9, 3.5658931501074553`*^9}, {
  3.5658931855093746`*^9, 3.565893364051688*^9}, {3.5658935067139387`*^9, 
  3.565893553950822*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Field given by the finite-difference field model\
\>", "Subsection",
 CellChangeTimes->{{3.565730400722845*^9, 3.5657304794093833`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Vmatrix", "=", 
   RowBox[{"Import", "[", 
    RowBox[{"FileNameJoin", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"NotebookDirectory", "[", "]"}], ",", "\"\<Bmatrix.dat\>\""}], 
      "}"}], "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Dimensions", "[", "Vmatrix", "]"}]}], "Input",
 CellChangeTimes->{{3.565831234014286*^9, 3.5658312885544057`*^9}, 
   3.565831321480289*^9, 3.5659613982435875`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1201", ",", "961"}], "}"}]], "Output",
 CellChangeTimes->{3.565831323231389*^9, 3.565893413456975*^9, 
  3.566057410372883*^9, 3.566567856776495*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Clear", "[", "Binterp", "]"}], "\[IndentingNewLine]", 
 RowBox[{"Binterp", "=", 
  RowBox[{"Interpolation", "[", 
   RowBox[{
    RowBox[{"Vmatrix", "[", 
     RowBox[{"[", 
      RowBox[{"All", ",", "2"}], "]"}], "]"}], "/", 
    RowBox[{"Vmatrix", "[", 
     RowBox[{"[", 
      RowBox[{"1", ",", "2"}], "]"}], "]"}]}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.5657307048765793`*^9, 3.565730735983034*^9}, {
   3.565730801518749*^9, 3.5657308049663553`*^9}, {3.5657308529208393`*^9, 
   3.5657308554636436`*^9}, 3.565730911982543*^9, {3.5657325382853994`*^9, 
   3.5657325454770117`*^9}}],

Cell[BoxData[
 TagBox[
  RowBox[{"InterpolatingFunction", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"1.`", ",", "1201.`"}], "}"}], "}"}], ",", "\<\"<>\"\>"}], "]"}],
  False,
  Editable->False]], "Output",
 CellChangeTimes->{3.5657309138389463`*^9, 3.5657325477234163`*^9, 
  3.565741653238632*^9, 3.5657866828970184`*^9, 3.565788037806198*^9, 
  3.5658313384532595`*^9, 3.565893413488175*^9, 3.5660574104040833`*^9, 
  3.5665678568076954`*^9}]
}, Open  ]],

Cell[BoxData[{
 RowBox[{"Clear", "[", "Bmodel", "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Bmodel", "=", 
   RowBox[{"Function", "[", 
    RowBox[{
     RowBox[{"{", "r", "}"}], ",", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"r", ">", "3.0"}], ",", "0.0", ",", 
       RowBox[{"Binterp", "[", 
        RowBox[{"1", "+", 
         RowBox[{"r", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"Length", "[", "Vmatrix", "]"}], "-", "1"}], ")"}], "/", 
           "3.0"}]}]}], "]"}]}], "]"}]}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.5657310147399235`*^9, 3.5657311058128834`*^9}, {
   3.5657312649175625`*^9, 3.565731302591629*^9}, {3.5657313470517073`*^9, 
   3.565731349313711*^9}, {3.5657314178446317`*^9, 3.5657314558930984`*^9}, {
   3.5657448472627306`*^9, 3.565744852192339*^9}, {3.565831379227592*^9, 
   3.5658313848089113`*^9}, {3.5658314872090797`*^9, 3.5658314904694858`*^9}, 
   3.565831586144454*^9, {3.5658317058746643`*^9, 3.565831716529483*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LogPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Bmodel", "[", "x", "]"}], ",", 
     RowBox[{"Bmass2", "[", "x", "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "3"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.5657309180665536`*^9, 3.5657309429797974`*^9}, {
  3.5657311224113126`*^9, 3.5657311297745256`*^9}, {3.5658936005013037`*^9, 
  3.56589361583613*^9}, {3.5658942339984236`*^9, 3.5658942719844904`*^9}}],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJxF1nk81N/3OPCxjq3sZQ+JFlJoUelMEaWEIqUsCdkKLUJkUslaypJQlix5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      "]]}, 
    {Hue[0.9060679774997897, 0.6, 0.6], LineBox[CompressedData["
1:eJxTTMoPSmViYGCQBGIQ/cM7b25AfoEdAxS0pahrnFfzs4fxz757ktWrFgfn
f9js3JOjlgfnN4l9lolRq4PzTx/3ehqs1gfn5y8oO+mvNg/OP9jTs9tXbR2c
z8pWxP4yaz+c71mf2Lo17Dicv70y9e7Si+fg/JtR2fpF5ZfhfEH33rSDDtfh
fIErqZvMo2/D+coKOStbk+7D+RZ3c087TnqIcM+vBp8rsx/D+Rn7T5zY1/QU
zp+ZvFxKNOE5nJ/jLXFIJwPBtzPuzHQpQPAfMWXvKG5A8HUW6YVdWoDg73uw
dWL/QwRf76DAu/exL+B8AHdQYrY=
      "]], LineBox[CompressedData["
1:eJwBYQKe/SFib1JlAgAAACUAAAACAAAAciSOVpxt6D+51hSVYqAPv4gtplc5
c+g/a/N9m/sjG79aFRf/UHvoP+JbHgFXvCW/LP2HpmiD6D9pSFCL0eYtv3ac
S0THo+g/8fHKlgRJP78I29J/hOToP4hfRX+u+0+/LVjh9v5l6T9/Zd2TEixg
v5wSP/6Lbek/w41NgDSmYL8KzZwFGXXpPwN15z5YIGG/6EFYFDOE6T8vKtAy
pRRiv6QrzzFnouk/53z69lT9Y78a/7xsz97pP4cA4PwLz2e/BqaY4p9X6j/Y
wnhg2HNvv3Vg9uksX+o/61gcrTTub7/kGlTxuWbqP2Hf02ZJNHC/wY8PANR1
6j8p8lZFqq5wv3x5hh0IlOo/IZn/+najcb/yTHRYcNDqP/E8+k48jXO/3vNP
zkBJ6z8IJKDKdmF3v44b1yNwUes/amP3zOejd78+Q155n1nrPxmPOuNZ5ne/
n5JsJP5p6z9Ed6hLQWt4v2AxiXq7ius/nlYdDR11eb8QWRDQ6pLrPyC2zq+W
t3m/wYCXJRqb6z8Wq7NmEfp5vyLQpdB4q+s/vzc8EQp/er/jbsImNszrPwb+
QloIiXu/lJZJfGXU6z+nN4yfist7v0S+0NGU3Os/1c5Q+Q0OfL+kDd988+zr
Py8AcOoXk3y/VDVm0iL16z/jktyBntV8vwVd7SdS/es/LHDoLSYYfb9mrPvS
sA3sP+MBAsQ4nX2/FtSCKOAV7D9TryGuw999v8b7CX4PHuw/aJ4ErU8ifr92
I5HTPibsP/vLs8DcZH6/+Z3xIlEs7D+0bdR7O5Z+v/FZNS4=
      "]], LineBox[CompressedData["
1:eJwVlHk8lAkcxgklKawoOylF0+HoWC3a6ufK0aHS4YhxZGgVNmEnKVfFTFFo
amQjEamUDpWoXzrt1JZkxpGZNOUo7/vO+05rFYu1fzyf5/P95/l8/3pmh8Z4
c8epqalxxvJ/r1SPOTr8CwHRp78XZmfyMfMMu/nlKgLEP/8aG5nAR/tHlQv+
dSPAdYlaBuHJx97PtsmWGwhgjd95Sb6AjyKDumZ/HwKWR1m4Oxrz0cPBZaEg
iAA/nXvqBnp8/BYsTq6JIKBbdvHuxql8rMjcJOmNIUC2IvLQ6Fw++le1LpzO
I8B8XewdU1c+6rQGpbinEOCmtUx+OZqP90a7JQmZBEyptcFLF/gYOS/asuwE
AUXzaX/WZz7+uKE/RSIi4OpEG2LEXoAvEpKkmsUE2K9o7tkmFGBSoYaVbQUB
CdEzhi1GBGj1TJC64zoB8QEXjXbtPYodpEFLbg0BN0uLtlr2H8VjRvlWj+oJ
0Fj0hrUz/RiSYeUtZk0EFL917Qh5moWFx2ysN7YTYL2/4Z7Fvmz0ulWdlqwg
IL+O2xvjcByvajyxlqsIoH7f8VgacwI5lmvTJw8R0Fyj2fFWcQL1Nje1rtAg
wcef6pgRkIO/ne9MLzAkwTrzVUlBSC6aiSPaxCwSqlO+/iIlc7GRoWwGzUkI
mawTEp6Sh0uchtt8bUkY8OR55N49iar3JouNt5Lw3TCFtTv+NJrtGLCdFTjG
AYFd05aIcEN3s8N8Lgl9pnD2H5UIrxDHXZbHk9AS16/y55/B8O9aPhwhCbR3
cvl89UI8mfRxe8RZEhJlA6nNVCE+Hn0Y/NsFEoqN15c0KYrQbHxSZFo1Ca0Z
afI+6hy2/6A6UCYh4erSXlitX4Lap16nXZORwJ1nv7fsXAnamVRm3O0iIWqO
gudqW4onZ+3MEfeTMN5lwNCZewG9rOSllBEF37gzDYRUOdavFr/4eRsFxv2D
XqHFlUg3lDcChwKv2re6GhFXcea6wxKPcAoWurj7GC2+honeju/9EyiYfynI
bkN4FdoG3VYdPEVBXKqFzbtpN/Ai77zJcykFOnzWOFVjNUqHkmc2yqkx/+Cc
zRtvo1ZyoHlbNwW+D2Nrc9/cxtDD0637/qGgx8AJb7XdwRm52Y5605RwRT07
T6p2D09cTozw8VHCd+ndVPvKB7hdffVLCUcJwtHIPiMnRLaP3pIt4UrY6/ZB
44EUsW5c6eDGeCWUU4op99MfYq/fX1lr8pTgL/Hr34/1CNpmt1a+VsLUjEdD
e8OeoA7ny/Q6qRL+1S3N5N1/gs03bx1YLleCjpMi7MC0pxgZ5OluRyqhWzNK
dvzVU1y73SFKpEXD8LX8FH3P5/j7jVC1XHMaTPehN3ePGANkz5dumkeD84Sz
7bvfidFZ25qrb0nDHq6un8jtBepyBv7MXkqDt2NBAdfsJZ6feCzvqBMNIy+q
RBaKv/BVcDX7cBANjQMlvMDGRmTraa/nFdAwt4LT8Fpfglfo1LLMIhq06xvm
7AmR4NKmoVFRCQ0FzqE5ajclCELljZrLNLjPTBzq95WiL6tl+lAtDZrskFXC
qhYUzCv7dKCDhnVFw2RNTjvqTzRbld1Jw1eRh2mLqh1Pfck/XfiJBsHHnkmm
W99hSWXWGiRo2N51aeEy0w6s+ym+Sm2YBvnX4NmsOhlS4JqUbspAj+kUrYo/
OjFu9gNJ3mwGLIWz3lW2dOLgOPtFpXMZOLgyQxlr+AEnPLNUPLFmgFfLLlub
9QHN1hl6jF/FQMNWgeysQIFl1lnFxs4MOPUcEeq8VKCV3oQhthsDngVhmtum
fESHpsFKdy8GKtaGZp8RfkRvX4UhnzO2b7JfPfDaJ2x1CIjKD2XAT3nd0enb
J+SwpM8qwhkgQkYWWDp34S75n/vE0Qz8/cz4ArutC1Xo8rY9loGx09B2ZXcj
r/i+VV8CA3Ff6vFgXDeOpNkdGUpkYMsp3eWyx914KOz6+0nJDEwS+5uHT+3B
1NCEcpN0BqhSI1+C24P/AXeSJCs=
      "]], LineBox[CompressedData["
1:eJwVxXs0VHkcAHClWHtSp87kkYqQHOu0G2qNpW+KJSSWUqLH9E4eu+2xPZTx
WJU8d4SGoTxWqCnSRmZ8D2epJZvkyETbQ81Iyty5vzsz91bs7h+f81kmiP9h
/0wDA4PA//y/He/28GQmBYHeI4s2r1OimYn1hOcFCkTRD3sCNyhRMl7suymX
gtfy54KqGCXaP1hQHi2iYKtVyZRRgRLrrmfpY4soGG8+kn5MpsQ/EoT1OeUU
nDNa+fKwqQozW9VN2yspKHOP6gVXFe4y2tNmX0OBlHnzacl2FX5R6v3orpSC
ZIVTl6ZKhZH3ZuqUcgoCKPuNHz3HcGrJr+thhIKCksd/JsS9Rd+e84pJCw2k
fz0isRh8hwPLRcahv2kggd/Z8SpCjRtXWLjHFmogyKki+d1RNbY5Sg6dF2tg
r8hapUlRY+1XNX+1V2hgiG4z/VyvxjOrWi+43NKAXYfuEzutRkev0Xm8AQ2k
GTbsjauhMCnc1eLJQhpmB5qqn2k0SG1p9qctaUgXX+ftNKbxQITXiXlLaTge
9l3koBWNoZF+T/0caJhpUPC91IdGh907SpvX0FDKnYsjF2nsi0mzEUfQ4Fwc
0SlZQ9A+7bFj9CUa/tm3yTIyjsFtjYarDkhooLKyZZyQwayXrvz4KzT4ZU1L
MkUMMlCwMaWWBuOesJ7EZga7PoUfqW6h4frwspO/zNDi4cTB+vcKGorM3sX0
5mqxrNqoSfuMhrYX1mv5V7TYP7BGNv2ShuHXbztzGrXo4Vr0YP44DYF6NyEz
oMU56oj3qzkaMuZ7BNRY6FB6WLHyzCIClcPdlv4lOnxVbPLt2aUEHl4xTLOt
16H5fT7k2RLodo8vfnFXh0IH8eYKJwJ4hvCNnuowdDQyocuDQEb4zzETZnok
USMNc3cQmOHu3fEgU4+OWXPumu8ikNqhnXWrWI9RrZ4dNnsJbJjcdzPxdz12
Wkr6XWIIOF3ubCho12PhYDS99RSBAUXVaRutHvkhz93KSwg8rutbt2wbi7Kx
2e8F5QS8Gg6KxwUsrk1xrnaoJGBZoMvPi2XRp/HEQmkdgezcCecfU1kM5vG0
shYCLUm1H5LqWOy75iEVygnYBtvPt2tiMcx3zwGfdgIfukTplXIWtyVKB3vu
E+gPWOzj0seiYMj/ztMnBO598C9Opll8nRAfXzZMICTK7qb6I4sHTQpXCJ4T
GM2/refP4vCox2jRWyWByTGFVTiPw8TS08f1DIF8XvmzchcO9W5V38hYAl9q
yq728Dk81ds9lvyZwJTcRt67jkPhlPl249kMPNqT9yosmMMLuxv5ZjwGTO7P
9RIc5HAuO0QpzBlIXV93xCOWw7z86VqJFQP7dgaA6icOCzuCFi23Y2CkZbFd
22kOLXYc6x9zYGBLmeeQKpXDEvpS5jUnBsQqX+Gbsxxetldxri4MnLvhZxiV
z6Gt3PSWbjUDmfrGnIGLHFZvcYtp5TOQ3c7E2og5rMtIGV7vzcBZ06miVRUc
OltfFRn5MlDdvqFMW83hjTt/B3b7MxDceyg+p5ZDlxDGMCeIAe0bnNBf47Bp
zEoWGsJA0sN57OqbHAZBxMjJUAZ2Lji237mBw38BLtiq0g==
      "]], LineBox[CompressedData["
1:eJwVj2tMk2cYhtu+n6wDy2ExlnEwIhvFOUBBEbTzYSoHAWkxo86oODUTBkiJ
AW2UAlMUFHVyPqPAEnE6EGRVFPme4YAq1Clzm6LsgIhFhKH4Qfu9A8d+3Llz
5f5x5XbZpd70pUggEKybzf89Nl5oG7mFg+1ddQGeRp6VN30zWLGVA3GtbaFk
jGfbQnUVX+zgwMa1b7B+imcDnj757IPdHKDftxaRQsreOkQkxj0cvIiJM01Y
UlZ/SalVJ3KQIbi1Tr6AsqGBB1b47OOge7Vv6d8yyhr6K0cnUzhIcYvRZS2j
bK/1yPY0LQebrfPgt/WU7U86uubUSQ7OVlNlajxlm/y3SDpyJ0FR82BizHqG
na/qelR3dArKnFeGmD8VIAwIctuTTZD/rt7uSbwQbdNfL7inMcHH30l3sklC
HHAcvNSfagLf6N7xcylCzIzq0psyTWDojr4ZnS7EO/pTAq9CE3jbf576U54Q
VQ0OSeU/mEDLu1kubxFiQupyRfKkCZ5Xf/1Ky4iwdH6sxE1jhjSVDUnPF+E1
J2XY2CEzqMTp09piET5c5Hdcl26GGv9qn4PlIrT3Es8JzjLDU0XCmrhaERYF
1/0bU2SG4Cv5n7hfEWGBxjhyodkMp0Zao6S9IjzdF3vH45UZclUjDpUSgvV/
KcWTb8zAu8TE+dsRNAz5BbWZzBDUzWzsnUdw7oS4PULAw5y93jqzI8Ecqwst
ahseZKzk8IKPCGbLh+saPXh4pt8QfiOQ4OGqr7JWxPHg2yOb73SQ4Nqte15G
JPJgoD5VR7QEif3uyNh9POSk7FUNZRDMzN3mWH6Qh7cJWnllFsFjmYoGQQ4P
w4/DXe8VEDwet+L37os86DY9yl5fTzBU5i1/1sBDkvPCia2NBC0HPatnrvDg
uTrTNbGZ4Int7vHLWnmQrLvWevg6wZNKx7dFPTy8M37MKaGT4BlfoWzXKA9N
QzrRqn6CyonpnEOveHieYXmf/5Og3WV+vICb/RuSJtANEMxb/OZ61zQPDi+S
4xyNBPOdnkd4WFOwFjq3V78mWCQy7Dd5UuDaOjcXWzCoYm8/tvOhEKI/r6Zi
BqWpnQFLVlJoFK/K2WLFYAnHWkYDhV/it10ltgyWGZuqbikoCG4Ehtm8z2Dl
3ZLO00kUnMvY9pnFDDq1BJDCZApTacfXTi1hsKLWCOUaCq7hXt8PezBYrvFr
OZ9BYZGsb2nrMgZLFz28iGcoDAz9miz1Z9BekmHsLKCQ3bH57h+rZv1Tsg8N
JRRSRzP/OStnsLjnQNWjcxRK83w0NgEMFu6X5r6+TKH+6pultUEMztvJGkzN
FH6+mxPlF8JgQViM5dtrFMyVHS5dG2Z3X5vgOTcp7CH9uYowBvMXXj1i9SMF
Rb5Dzf1wBt+z2oF2HRSGmh9EbIxgMI+zmJbepuDOqgvaFQzOdVYPv5xl9R1m
1FrJ4H8BzRr4
      "]], LineBox[CompressedData["
1:eJwB0QMu/CFib1JlAgAAADwAAAACAAAArs6tHcPR+z8AFzF4LsoEwBC1/rIq
1fs/8G9dstvMBMCQn6bvMNn7PybfjAUG0ATAj3T2aD3h+z9/eZncW9YEwI0e
lltW8fs/AcevTAzjBMAMCT6YXPX7P90rTGY55gTAjPPl1GL5+z85iUnlZukE
wIvINU5vAfw/rcJIE8PvBMCJctVAiBH8PwIEey6A/ATAhcYUJrox/D8k+C9a
DRYFwH1uk/Adcvw/iB+9QXNJBcBKwjHd3nX8Py3aEmV1TAXAGBbQyZ95/D98
+H3fd08FwLS9DKMhgfw/jhNp2X1VBcDqDIZVJZD8P+xIW+CNYQXAWKt4uiyu
/D918XMwvnkFwDToXYQ76vw/mFJWf1+qBcDrYSgYWWL9PweT8XmhDAbAi/3q
BN5m/j9PpUgsI+YGwLrsR+8OWv8/vx1zgyW2B8DWJTjiOiQAQJ2cywHvhQjA
aCljL5OlAEA1zw3iZ2oJwMFWW3tBHgFAX+qMg5RACsAzWOqpFKEBQPXDqcv+
JgvAbING1z0bAkDDuWjU7PgLwIhmCPoBkwJAA1Y0PIK9DMC9HWH/6hQDQBy1
Hmdjgg3AQLVx+88WA0DmWaAKGYUNwMRMgve0GANA2UeXV82HDcDMe6PvfhwD
QL4fN+cxjQ3A3Nnl3xIkA0DQDV+u6pcNwPyVasA6MwNAzh6eYxmtDcA7DnSB
ilEDQGIn44tf1g3AvqWEfW9TA0CXOZIY59gNwEI9lXlUVQNAm19kGG3bDcBK
bLZxHlkDQK0cj2p04A3AWsr4YbJgA0DRKb0ocOoNwHqGfULabwNAUEjCiRr+
DcC5/oYDKo4DQAnbU8EuJA7AjvEhkzeQA0Dhff0DsyYOwGLkvCJFkgNAYbxt
MzUpDsAKyvJBYJYDQOqe0k8zLg7AXJVegJaeA0AOvAxBFjgOwDCI+Q+koANA
0g5JrIk6DsAEe5SfsaIDQBy2svL6PA7ArWDKvsymA0BLdEYI10EOwP4rNv0C
rwNAcnEOGXVLDsDSHtGMELEDQFIkUiDXTQ7ApxFsHB6zA0Cjyz3xNlAOwFD3
oTs5twNAoXFS5+9UDsAk6jzLRrkDQLxvHwhJVw7A+NzXWlS7A0DVa9zpn1kO
wKHCDXpvvwNABVx050ZeDsB2tagJfcEDQKvH9/6WYA7ASqhDmYrDA0BoK7zO
5GIOwB6b3iiYxQNAaFSXVDBlDsDyjXm4pccDQE+6X455Zw7AxoAUSLPJA0C6
hOx5wGkOwJtzr9fAywNA95AVFQVsDsD8gzW8MM0DQLY0EiCabQ7AgrS4Iw==

      "]]}, {}}, {{}, {}, {}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, -3.9836884481742296`},
  CoordinatesToolOptions:>{"DisplayFunction" -> ({
      Part[#, 1], 
      Exp[
       Part[#, 2]]}& ), "CopiedValueFunction" -> ({
      Part[#, 1], 
      Exp[
       Part[#, 2]]}& )},
  FrameTicks->{{{{-4.605170185988092, 
       FormBox[
        TagBox[
         InterpretationBox["\"0.01\"", 0.01, AutoDelete -> True], 
         NumberForm[#, {
           DirectedInfinity[1], 2}, NumberPadding -> {"", "0"}]& ], 
        TraditionalForm]}, {-3.912023005428146, 
       FormBox[
        TagBox[
         InterpretationBox["\"0.02\"", 0.02, AutoDelete -> True], 
         NumberForm[#, {
           DirectedInfinity[1], 2}, NumberPadding -> {"", "0"}]& ], 
        TraditionalForm]}, {-2.995732273553991, 
       FormBox[
        TagBox[
         InterpretationBox["\"0.05\"", 0.05, AutoDelete -> True], 
         NumberForm[#, {
           DirectedInfinity[1], 2}, NumberPadding -> {"", "0"}]& ], 
        TraditionalForm]}, {-2.302585092994046, 
       FormBox[
        TagBox[
         InterpretationBox["\"0.10\"", 0.1, AutoDelete -> True], 
         NumberForm[#, {
           DirectedInfinity[1], 2}, NumberPadding -> {"", "0"}]& ], 
        TraditionalForm]}, {-1.6094379124341003`, 
       FormBox[
        TagBox[
         InterpretationBox["\"0.20\"", 0.2, AutoDelete -> True], 
         NumberForm[#, {
           DirectedInfinity[1], 2}, NumberPadding -> {"", "0"}]& ], 
        TraditionalForm]}, {-0.6931471805599453, 
       FormBox[
        TagBox[
         InterpretationBox["\"0.50\"", 0.5, AutoDelete -> True], 
         NumberForm[#, {
           DirectedInfinity[1], 2}, NumberPadding -> {"", "0"}]& ], 
        TraditionalForm]}, {0., 
       FormBox[
        TagBox[
         InterpretationBox["\"1.00\"", 1., AutoDelete -> True], NumberForm[#, {
           DirectedInfinity[1], 2}, NumberPadding -> {"", "0"}]& ], 
        TraditionalForm]}, {0.6931471805599453, 
       FormBox[
        TagBox[
         InterpretationBox["\"2.00\"", 2., AutoDelete -> True], NumberForm[#, {
           DirectedInfinity[1], 2}, NumberPadding -> {"", "0"}]& ], 
        TraditionalForm]}, {1.6094379124341003`, 
       FormBox[
        TagBox[
         InterpretationBox["\"5.00\"", 5., AutoDelete -> True], NumberForm[#, {
           DirectedInfinity[1], 2}, NumberPadding -> {"", "0"}]& ], 
        TraditionalForm]}, {-3.506557897319982, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-3.2188758248682006`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-2.8134107167600364`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-2.6592600369327783`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-2.5257286443082556`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-2.4079456086518722`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-1.2039728043259361`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-0.916290731874155, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-0.5108256237659907, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-0.35667494393873245`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-0.2231435513142097, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-0.10536051565782628`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {1.0986122886681098`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {1.3862943611198906`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}}, {{-4.605170185988092, 
       FormBox["\"\"", TraditionalForm]}, {-3.912023005428146, 
       FormBox["\"\"", TraditionalForm]}, {-2.995732273553991, 
       FormBox["\"\"", TraditionalForm]}, {-2.302585092994046, 
       FormBox["\"\"", TraditionalForm]}, {-1.6094379124341003`, 
       FormBox["\"\"", TraditionalForm]}, {-0.6931471805599453, 
       FormBox["\"\"", TraditionalForm]}, {0., 
       FormBox["\"\"", TraditionalForm]}, {0.6931471805599453, 
       FormBox["\"\"", TraditionalForm]}, {1.6094379124341003`, 
       FormBox["\"\"", TraditionalForm]}, {-3.506557897319982, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-3.2188758248682006`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-2.8134107167600364`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-2.6592600369327783`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-2.5257286443082556`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-2.4079456086518722`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-1.2039728043259361`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-0.916290731874155, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-0.5108256237659907, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-0.35667494393873245`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-0.2231435513142097, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-0.10536051565782628`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {1.0986122886681098`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {1.3862943611198906`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}}}, {Automatic, Automatic}},
  GridLines->{None, None},
  Method->{},
  PlotRange->{{0, 3}, {-3.9836884481742296`, 0.}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]},
  Ticks->{Automatic, {{-4.605170185988092, 
      FormBox[
       TagBox[
        InterpretationBox["\"0.01\"", 0.01, AutoDelete -> True], 
        NumberForm[#, {
          DirectedInfinity[1], 2}, NumberPadding -> {"", "0"}]& ], 
       TraditionalForm]}, {-3.912023005428146, 
      FormBox[
       TagBox[
        InterpretationBox["\"0.02\"", 0.02, AutoDelete -> True], 
        NumberForm[#, {
          DirectedInfinity[1], 2}, NumberPadding -> {"", "0"}]& ], 
       TraditionalForm]}, {-2.995732273553991, 
      FormBox[
       TagBox[
        InterpretationBox["\"0.05\"", 0.05, AutoDelete -> True], 
        NumberForm[#, {
          DirectedInfinity[1], 2}, NumberPadding -> {"", "0"}]& ], 
       TraditionalForm]}, {-2.302585092994046, 
      FormBox[
       TagBox[
        InterpretationBox["\"0.10\"", 0.1, AutoDelete -> True], NumberForm[#, {
          DirectedInfinity[1], 2}, NumberPadding -> {"", "0"}]& ], 
       TraditionalForm]}, {-1.6094379124341003`, 
      FormBox[
       TagBox[
        InterpretationBox["\"0.20\"", 0.2, AutoDelete -> True], NumberForm[#, {
          DirectedInfinity[1], 2}, NumberPadding -> {"", "0"}]& ], 
       TraditionalForm]}, {-0.6931471805599453, 
      FormBox[
       TagBox[
        InterpretationBox["\"0.50\"", 0.5, AutoDelete -> True], NumberForm[#, {
          DirectedInfinity[1], 2}, NumberPadding -> {"", "0"}]& ], 
       TraditionalForm]}, {0., 
      FormBox[
       TagBox[
        InterpretationBox["\"1.00\"", 1., AutoDelete -> True], NumberForm[#, {
          DirectedInfinity[1], 2}, NumberPadding -> {"", "0"}]& ], 
       TraditionalForm]}, {0.6931471805599453, 
      FormBox[
       TagBox[
        InterpretationBox["\"2.00\"", 2., AutoDelete -> True], NumberForm[#, {
          DirectedInfinity[1], 2}, NumberPadding -> {"", "0"}]& ], 
       TraditionalForm]}, {1.6094379124341003`, 
      FormBox[
       TagBox[
        InterpretationBox["\"5.00\"", 5., AutoDelete -> True], NumberForm[#, {
          DirectedInfinity[1], 2}, NumberPadding -> {"", "0"}]& ], 
       TraditionalForm]}, {-3.506557897319982, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-3.2188758248682006`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-2.8134107167600364`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-2.6592600369327783`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-2.5257286443082556`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-2.4079456086518722`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-1.2039728043259361`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-0.916290731874155, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-0.5108256237659907, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-0.35667494393873245`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-0.2231435513142097, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-0.10536051565782628`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {1.0986122886681098`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {1.3862943611198906`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}}}]], "Output",
 CellChangeTimes->{
  3.5657309442901998`*^9, 3.5657311313189287`*^9, 3.5657314724447274`*^9, 
   3.565741653271634*^9, 3.5657866829282184`*^9, 3.5657880378373985`*^9, 
   3.565831501514305*^9, 3.5658315923844647`*^9, 3.5658317210222907`*^9, 
   3.565893413519375*^9, 3.565893617224533*^9, {3.5658942463224454`*^9, 
   3.565894273419693*^9}, 3.5660574107628837`*^9, 3.566567857072896*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Chosen B-field model should be assigned to B[r]:\
\>", "Subsection",
 CellChangeTimes->{{3.565730400722845*^9, 3.5657304794093833`*^9}, {
  3.565731731639183*^9, 3.565731760296433*^9}, {3.5657330041022177`*^9, 
  3.5657330177990417`*^9}}],

Cell[BoxData[{
 RowBox[{"Clear", "[", "B", "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"B", "[", "r_", "]"}], ":=", 
  RowBox[{
   RowBox[{"Bconstant", "[", "1.5", "]"}], "[", "r", "]"}]}]}], "Input",
 CellChangeTimes->{{3.5356586586103277`*^9, 3.5356586849328337`*^9}, {
   3.565731541022448*^9, 3.5657315516148663`*^9}, {3.565732563089443*^9, 
   3.565732568206252*^9}, {3.5657326372675734`*^9, 3.565732639373577*^9}, 
   3.565735280395816*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"B", "[", "r", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"r", ",", "0", ",", "3.5"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.5356586896041007`*^9, 3.5356587036249027`*^9}, {
  3.565732643788385*^9, 3.565732645535588*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJxNywlIkwEUB/BvyzyDUXaM8iib4bQUsyjnsUwbi+zLq2ORpKaVrTHnmUVm
dlhiHmhOO7SV5lXSEjR0MVLpQKVpnoSrzAPNtOXUqdN1UO/twePx4//+G8KE
ARFUgiCO/t4/V3KksvbG5hhP4u/8YI9tvbadlydh/7eoVEY9kicFOzo+LXge
2AB2kKuikljNYEqqgr9vrg1cnhuwY2lNFzjv4oGHX9Z/BMtb4kv4o5/A/JdM
TSvZD6anHBTMXBoAf03Mq0r4PAT2+5TLvkkfAbuoBWrBnm/g7e7H4sol38G9
KiNOfOcEmBSEq3wtVOAzrs/9udyf4MMyJW9ZyCS4o2fV2wuZarDNEwdldcUU
OKvf7Z6tzzRYR/c9Ku5D26a9vz9qNwPeNx/wxSMWraxeeWW4AC0628XIlqPr
uLVTEe1oA9v816xBNDPH2KlkHE1SEsU0DTpkp7S5SYuOFo7oEimafyaIq483
bHMyRIv7eKcHTPXyTGc5l4aO9jJZ/dQcTZa8aIyzQBsI1lgbOer9azs6mf5o
33V+3kIxmuBxrOY2zoI1Ag9WfdAc+JWr+aKPaB68J7grcOcNLZi3tpjWXbMA
9szwi/FsWwT3tl4pLKMQu/5bRBxqGRKjozPWkCYMCpgVqUyhyND8olwz5V4q
OPGyV/BEB/rAs8nQLv4S8C3W7TqJBp2z3P317mwDMNWn3fat9VIwaXOcTKlE
h+1XMVd4G4KVH6J51xVom9JZN0WkEdh7U8IwSRiDW4mBIWk62truUMEowwTc
W1FbZFSNFvXShDxPU7AiSKBK7kTnO9S9SQ8zA/eMxOZSI9D0MqfQc6fQBYyS
uRNn0Xcss7a4xaPv0k7mjNxEF04uP86RopXSFgdZNdoqKlXjXIMuGtNmW9aj
HwwON6mb0JLul/aPetD9t8/N0D+ibYJcmjL60A8VZcHn+/X8LifLf0yvn0oG
vxnX63NM7D1U6EcNSY120+iBZNesQg2awVYfWzmPDl+oYqYtoIvrI6d1OvQv
QVB5NQ==
     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{0, 3.5}, {0., 1.}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{
  3.535658704501953*^9, 3.5657315555772734`*^9, 3.565732572012659*^9, 
   3.565732650231196*^9, 3.565735285122624*^9, {3.565741653292635*^9, 
   3.5657416625551653`*^9}, 3.565786682943818*^9, 3.5657880378529983`*^9, 
   3.5658317556387515`*^9, 3.565893413519375*^9, 3.566057410825284*^9, 
   3.566567857088496*^9}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Calculate a single trajectory step in x-y plane\
\>", "Section",
 CellChangeTimes->{{3.5657317742272577`*^9, 3.5657318237261443`*^9}, {
  3.565732739026552*^9, 3.56573274358176*^9}}],

Cell[CellGroupData[{

Cell["\<\
Step sizes (in x or \[Theta], depending on value of B-field)\
\>", "Subsection",
 CellChangeTimes->{{3.5657318767818375`*^9, 3.565731945858759*^9}, 
   3.565731987526432*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"dX0", "=", "0.002"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dT0", "=", "0.002"}], ";"}]}], "Input",
 CellChangeTimes->{{3.535658866072194*^9, 3.5356589131438866`*^9}, {
  3.5657353649323645`*^9, 3.5657353717339764`*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
function step[ ] calculates a new trajectory point and direction from a given \
one. Uses B[ ].
arguments:\
\>", "Subsection",
 CellChangeTimes->{{3.565732005014063*^9, 3.5657321039806366`*^9}, {
  3.5657329843369827`*^9, 3.5657330275178585`*^9}}],

Cell[CellGroupData[{

Cell[TextData[{
 "Point:",
 StyleBox[" {\[Theta], {x,y}} ", "Input"],
 ": ",
 StyleBox["\[Theta] ", "Input"],
 "= velocity angle to x-axis; ",
 StyleBox["{x,y} ", "Input"],
 "= position"
}], "Item",
 CellChangeTimes->{{3.5657321712635546`*^9, 3.5657323215698185`*^9}}],

Cell[TextData[{
 "Radius of curvature:",
 StyleBox[" R0", "Input"],
 StyleBox[" ", "Input"],
 ": normalized radius of curvature of trajectory path for B-field = 1.0"
}], "Item",
 CellChangeTimes->{{3.565732338948249*^9, 3.5657324911109166`*^9}}]
}, Open  ]],

Cell[BoxData[{
 RowBox[{"Clear", "[", "step", "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"step", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"\[Theta]_", ",", 
      RowBox[{"{", 
       RowBox[{"x_", ",", "y_"}], "}"}]}], "}"}], ",", "R0_"}], "]"}], ":=", 
  "\[IndentingNewLine]", 
  RowBox[{"Block", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"pos", "=", 
       RowBox[{"Sqrt", "[", 
        RowBox[{
         RowBox[{"x", "^", "2"}], "+", 
         RowBox[{"y", "^", "2"}]}], "]"}]}], ",", "r"}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"B", "[", "pos", "]"}], "\[Equal]", "0.0"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"Return", "[", "\[IndentingNewLine]", 
        RowBox[{"Which", "[", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"\[Theta]", "\[LessEqual]", "  ", 
           RowBox[{"Pi", "/", "4"}]}], ",", 
          RowBox[{"{", 
           RowBox[{"\[Theta]", ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"x", "-", "dX0"}], ",", 
              RowBox[{"y", "+", 
               RowBox[{"dX0", " ", 
                RowBox[{"Tan", "[", "\[Theta]", "]"}]}]}]}], "}"}]}], "}"}], 
          ",", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"Pi", "/", "4"}], "<", "\[Theta]", "<", 
           RowBox[{"3", 
            RowBox[{"Pi", "/", "4"}]}]}], ",", 
          RowBox[{"{", 
           RowBox[{"\[Theta]", ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"x", "-", 
               RowBox[{"dX0", " ", 
                RowBox[{"Cot", "[", "\[Theta]", "]"}]}]}], ",", 
              RowBox[{"y", "+", "dX0"}]}], "}"}]}], "}"}]}], 
         "\[IndentingNewLine]", "]"}], "\[IndentingNewLine]", "]"}]}], 
      "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"r", "=", 
      RowBox[{"R0", "/", 
       RowBox[{"B", "[", "pos", "]"}]}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"Which", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"r", "\[LessEqual]", " ", "0.7"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"\[Theta]", "+", "dT0"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"x", "-", 
            RowBox[{"r", " ", 
             RowBox[{"Cos", "[", "\[Theta]", "]"}], "dT0"}]}], ",", 
           RowBox[{"y", "+", 
            RowBox[{"r", " ", 
             RowBox[{"Sin", "[", "\[Theta]", "]"}], "dT0"}]}]}], "}"}]}], 
        "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{"\[Theta]", "\[LessEqual]", "  ", 
        RowBox[{"Pi", "/", "4"}]}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"\[Theta]", "+", 
          RowBox[{"dX0", "/", 
           RowBox[{"(", 
            RowBox[{"r", " ", 
             RowBox[{"Cos", "[", "\[Theta]", "]"}]}], ")"}]}]}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"x", "-", "dX0"}], ",", 
           RowBox[{"y", "+", 
            RowBox[{"dX0", " ", 
             RowBox[{"Tan", "[", "\[Theta]", "]"}]}]}]}], "}"}]}], "}"}], ",",
        "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"Pi", "/", "4"}], "<", "\[Theta]", "<", 
        RowBox[{"3", 
         RowBox[{"Pi", "/", "4"}]}]}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"\[Theta]", "+", 
          RowBox[{"dX0", "/", 
           RowBox[{"(", 
            RowBox[{"r", " ", 
             RowBox[{"Sin", "[", "\[Theta]", "]"}]}], ")"}]}]}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"x", "-", 
            RowBox[{"dX0", " ", 
             RowBox[{"Cot", "[", "\[Theta]", "]"}]}]}], ",", 
           RowBox[{"y", "+", "dX0"}]}], "}"}]}], "}"}]}], 
      "\[IndentingNewLine]", "]"}]}]}], "\[IndentingNewLine]", 
   "]"}]}]}], "Input",
 CellChangeTimes->{{3.535658918567197*^9, 3.5356589787066364`*^9}, {
   3.535659021345075*^9, 3.535659327100563*^9}, {3.53565936358265*^9, 
   3.535659427711318*^9}, {3.5356594660615115`*^9, 3.5356595964179673`*^9}, {
   3.535660277037897*^9, 3.5356603193393164`*^9}, {3.5356610632898674`*^9, 
   3.5356611078674173`*^9}, {3.5657325809358745`*^9, 
   3.5657326033063135`*^9}, {3.5657421652280197`*^9, 
   3.5657423221954956`*^9}, {3.565742389088413*^9, 3.565742408541647*^9}, {
   3.5657425784259453`*^9, 3.565742583963955*^9}, {3.565742627051231*^9, 
   3.56574264371206*^9}, {3.5657427421638327`*^9, 3.5657427710706835`*^9}, {
   3.565742818541567*^9, 3.5657428264351807`*^9}, {3.5657437945416813`*^9, 
   3.5657438160697193`*^9}, {3.565743848876577*^9, 3.5657438685638113`*^9}, {
   3.565744257878095*^9, 3.5657442652569084`*^9}, 3.5657450868167515`*^9, {
   3.5657451316356297`*^9, 3.565745141916048*^9}, {3.565788255707381*^9, 
   3.5657882781870203`*^9}}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Calculate a trial trajectory", "Section",
 CellChangeTimes->{{3.5657317742272577`*^9, 3.5657318237261443`*^9}, {
  3.565732724300126*^9, 3.5657327353761454`*^9}}],

Cell[CellGroupData[{

Cell["\<\
Resulting trajectory (list of points as in function step[ ]). Stops when \
trajectory has turned through an angle of \[Pi]/4 or trajectory crosses x = y \
line. Starts at specified x distance, uses provided R0.\
\>", "Subsection",
 CellChangeTimes->{{3.5657318767818375`*^9, 3.565731945858759*^9}, 
   3.565731987526432*^9, {3.565732798821457*^9, 3.565732858943963*^9}, {
   3.565732947879719*^9, 3.565732949283721*^9}, {3.56573304539549*^9, 
   3.565733106734798*^9}, {3.565733143972063*^9, 3.565733206871374*^9}, {
   3.565733254357857*^9, 3.5657332713150873`*^9}}],

Cell[BoxData[{
 RowBox[{"Clear", "[", "trajectory", "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"trajectory", "[", 
   RowBox[{"R0_", ",", "x0_"}], "]"}], ":=", "\[IndentingNewLine]", 
  RowBox[{"Block", "[", 
   RowBox[{
    RowBox[{"{", " ", 
     RowBox[{"points", "=", 
      RowBox[{"{", 
       RowBox[{"{", 
        RowBox[{"0", ",", 
         RowBox[{"{", 
          RowBox[{"x0", ",", "0"}], "}"}]}], "}"}], "}"}]}], " ", "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"NestWhile", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{"Block", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"pt", "=", 
            RowBox[{"step", "[", 
             RowBox[{"#", ",", "R0"}], "]"}]}], "}"}], ",", 
          RowBox[{
           RowBox[{"PrependTo", "[", 
            RowBox[{"points", ",", "pt"}], "]"}], ";", "pt"}]}], "]"}], "&"}],
        ",", "\[IndentingNewLine]", 
       RowBox[{"points", "[", 
        RowBox[{"[", "1", "]"}], "]"}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"#", "[", 
            RowBox[{"[", 
             RowBox[{"2", ",", "2"}], "]"}], "]"}], "<=", 
           RowBox[{"#", "[", 
            RowBox[{"[", 
             RowBox[{"2", ",", "1"}], "]"}], "]"}]}], "&&", 
          RowBox[{
           RowBox[{"#", "[", 
            RowBox[{"[", "1", "]"}], "]"}], "<=", 
           RowBox[{"Pi", "/", "4"}]}]}], ")"}], "&"}]}], 
      "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", "points"}]}], 
   "\[IndentingNewLine]", "]"}]}]}], "Input",
 CellChangeTimes->{{3.535659636746274*^9, 3.535659641321536*^9}, {
   3.535659737784053*^9, 3.535659741503266*^9}, {3.5356599246547413`*^9, 
   3.535659953804409*^9}, {3.5356599871173143`*^9, 3.535660064996769*^9}, {
   3.5356601373369064`*^9, 3.53566018478262*^9}, {3.535660217037465*^9, 
   3.535660226826025*^9}, {3.535660358137535*^9, 3.535660367121049*^9}, {
   3.5356611518229313`*^9, 3.5356611571102343`*^9}, {3.5356612497895346`*^9, 
   3.5356612546948156`*^9}, {3.5356617109629126`*^9, 3.535661737405425*^9}, {
   3.535661778720788*^9, 3.535661782329994*^9}, 3.5657332284306116`*^9, {
   3.565733289364319*^9, 3.565733425646158*^9}, {3.565733458733816*^9, 
   3.5657334717286386`*^9}, {3.565733927187039*^9, 3.5657339298390436`*^9}, {
   3.56573420673953*^9, 3.5657342142587433`*^9}}],

Cell[BoxData[{
 RowBox[{"Clear", "[", "evaltrajectory", "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"evaltrajectory", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\[Theta]_", ",", 
       RowBox[{"{", 
        RowBox[{"x_", ",", "y_"}], "}"}]}], "}"}], ",", "___"}], "}"}], "]"}],
   ":=", "\[IndentingNewLine]", 
  RowBox[{"If", "[", 
   RowBox[{
    RowBox[{"y", "<", 
     RowBox[{".99", "x"}]}], ",", "1", " ", 
    RowBox[{"(*", " ", 
     RowBox[{"too", " ", "tight", " ", "a", " ", "curve"}], " ", "*)"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"y", "\[GreaterEqual]", "x"}], " ", "&&", " ", 
       RowBox[{"\[Theta]", "<", 
        RowBox[{".95", 
         RowBox[{"\[Pi]", "/", "4"}]}]}]}], ",", " ", 
      RowBox[{"-", "1"}], " ", 
      RowBox[{"(*", " ", 
       RowBox[{"too", " ", "shallow", " ", "a", " ", "curve"}], " ", "*)"}], 
      ",", "\[IndentingNewLine]", "0"}], " ", 
     RowBox[{"(*", " ", 
      RowBox[{"just", " ", "right"}], " ", "*)"}], "\[IndentingNewLine]", 
     "]"}]}], "\[IndentingNewLine]", "]"}]}]}], "Input",
 CellChangeTimes->{{3.565733555485186*^9, 3.5657338859561663`*^9}, {
  3.565734219375552*^9, 3.565734227503166*^9}, {3.565735492524988*^9, 
  3.565735515800229*^9}}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Plot a trajectory", "Section",
 CellChangeTimes->{{3.5657317742272577`*^9, 3.5657318237261443`*^9}, {
  3.565732724300126*^9, 3.5657327353761454`*^9}, {3.565733987839946*^9, 
  3.565733994797558*^9}}],

Cell[BoxData[{
 RowBox[{"Clear", "[", "plottrajectory", "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"plottrajectory", "[", 
   RowBox[{"p", ":", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"_", ",", 
        RowBox[{"{", 
         RowBox[{"_", ",", "_"}], "}"}]}], "}"}], ".."}], "}"}]}], "]"}], ":=",
   "\[IndentingNewLine]", 
  RowBox[{"Show", "[", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"ListPlot", "[", 
     RowBox[{
      RowBox[{"Evaluate", "[", 
       RowBox[{"p", "[", 
        RowBox[{"[", 
         RowBox[{"All", ",", "2"}], "]"}], "]"}], "]"}], ",", 
      RowBox[{"AspectRatio", "\[Rule]", "Automatic"}]}], "]"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"Graphics", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Circle", "[", 
        RowBox[{"{", 
         RowBox[{"0", ",", "0"}], "}"}], "]"}], ",", 
       RowBox[{"Line", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"0", ",", "0"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"1", ",", "1"}], "}"}]}], "}"}], "]"}]}], "}"}], "]"}], 
    ",", "\[IndentingNewLine]", 
    RowBox[{"PlotRange", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", ".2"}], ",", "2.2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", ".2"}], ",", "1.2"}], "}"}]}], "}"}]}]}], 
   "\[IndentingNewLine]", "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"plottrajectory", "[", 
   RowBox[{
    RowBox[{"p", ":", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"_", ",", 
         RowBox[{"{", 
          RowBox[{"_", ",", "_"}], "}"}]}], "}"}], ".."}], "}"}]}], ",", 
    "R0_", ",", "opts___"}], "]"}], ":=", "\[IndentingNewLine]", 
  RowBox[{"Show", "[", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"ListPlot", "[", 
     RowBox[{
      RowBox[{"Evaluate", "[", 
       RowBox[{"p", "[", 
        RowBox[{"[", 
         RowBox[{"All", ",", "2"}], "]"}], "]"}], "]"}], ",", 
      RowBox[{"AspectRatio", "\[Rule]", "Automatic"}], ",", "opts"}], "]"}], 
    ",", "\[IndentingNewLine]", 
    RowBox[{"Graphics", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Circle", "[", 
        RowBox[{"{", 
         RowBox[{"0", ",", "0"}], "}"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"Dashed", ",", 
         RowBox[{"Circle", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"0", ",", "0"}], "}"}], ",", "R0"}], "]"}]}], "}"}]}], 
      "}"}], "]"}], ",", "\[IndentingNewLine]", 
    RowBox[{"PlotRange", "\[Rule]", "All"}]}], "\[IndentingNewLine]", 
   "]"}]}]}], "Input",
 CellChangeTimes->{{3.5356601996014676`*^9, 3.5356602009645452`*^9}, {
   3.5356603926305084`*^9, 3.535660425759403*^9}, {3.535660477212346*^9, 
   3.535660623596719*^9}, {3.535660664511059*^9, 3.535660688393425*^9}, {
   3.5356607506749873`*^9, 3.5356607776195283`*^9}, 3.535661162866563*^9, {
   3.5356625023351765`*^9, 3.535662516793003*^9}, {3.5657340255296116`*^9, 
   3.565734148052227*^9}, {3.565734244257596*^9, 3.565734252806411*^9}, 
   3.5657348630014825`*^9, {3.565734936664812*^9, 3.5657349963661165`*^9}, {
   3.5657455371115417`*^9, 3.565745546783559*^9}, {3.5657455794344163`*^9, 
   3.565745627544901*^9}, {3.5657457153730555`*^9, 3.565745726059074*^9}, {
   3.565745779925968*^9, 3.5657457832487745`*^9}, {3.5657458265544505`*^9, 
   3.5657458591585073`*^9}, {3.565787506625265*^9, 3.565787508856069*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Calculate and plot a trajectory for B-field model. Determine effective radius\
\>", "Section",
 CellChangeTimes->{{3.5657317742272577`*^9, 3.5657318237261443`*^9}, {
  3.565732724300126*^9, 3.5657327353761454`*^9}, {3.565733987839946*^9, 
  3.565733994797558*^9}, {3.5657342702628417`*^9, 3.5657342783436556`*^9}, {
  3.565734825374216*^9, 3.5657348436262484`*^9}, {3.565736424955109*^9, 
  3.565736446715354*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Clear", "[", "B", "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"B", "[", "r_", "]"}], ":=", 
  RowBox[{"Bmass2", "[", "r", "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"R0", "=", "1.158887"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"t", "=", 
   RowBox[{"trajectory", "[", 
    RowBox[{"R0", ",", "2"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"evaltrajectory", "[", "t", "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"path", "=", 
   RowBox[{"Interpolation", "[", 
    RowBox[{"t", "[", 
     RowBox[{"[", 
      RowBox[{";;", "20"}], "]"}], "]"}], " ", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Block", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"p", "=", 
     RowBox[{"Quiet", "[", 
      RowBox[{"path", "[", 
       RowBox[{"Pi", "/", "4"}], "]"}], "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"p", "[", 
      RowBox[{"[", "1", "]"}], "]"}], ",", 
     RowBox[{
      RowBox[{"p", "[", 
       RowBox[{"[", "1", "]"}], "]"}], "/", 
      RowBox[{"p", "[", 
       RowBox[{"[", "2", "]"}], "]"}]}]}], " ", "}"}]}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"plottrajectory", "[", "t", "]"}]}], "Input",
 CellChangeTimes->{{3.5356586586103277`*^9, 3.5356586849328337`*^9}, {
  3.565731541022448*^9, 3.5657315516148663`*^9}, {3.565732563089443*^9, 
  3.565732568206252*^9}, {3.5657326372675734`*^9, 3.565732639373577*^9}, {
  3.5657350912610836`*^9, 3.565735092087885*^9}, {3.565735159932404*^9, 
  3.565735161539207*^9}, {3.5657352290405254`*^9, 3.56573523719934*^9}, {
  3.5657352976338463`*^9, 3.565735298694648*^9}, {3.5657354126528482`*^9, 
  3.5657354131988487`*^9}, {3.565735557701903*^9, 3.565735559074705*^9}, {
  3.565735708054967*^9, 3.5657357288810034`*^9}, {3.5657357608766594`*^9, 
  3.565735783293899*^9}, {3.5657360762000136`*^9, 3.56573623282712*^9}, {
  3.5657362934505873`*^9, 3.565736364333642*^9}, {3.56574323003909*^9, 
  3.5657432500539255`*^9}, {3.565786761786357*^9, 3.565786832891282*^9}, {
  3.565831810051647*^9, 3.5658319281750546`*^9}, {3.565893734739539*^9, 
  3.5658938697889767`*^9}}],

Cell[BoxData["1.158887`"], "Output",
 CellChangeTimes->{{3.5657357413298254`*^9, 3.565735784869502*^9}, {
   3.565736079382419*^9, 3.565736233887181*^9}, {3.565736295782721*^9, 
   3.5657363666097717`*^9}, 3.56574168711257*^9, 3.5657428673540525`*^9, 
   3.565743254484333*^9, 3.565743633081398*^9, 3.565786683006219*^9, {
   3.565786764251161*^9, 3.565786834264084*^9}, 3.5657875757333865`*^9, 
   3.565788037884198*^9, {3.565831798117626*^9, 3.5658319296258574`*^9}, 
   3.565893679749443*^9, {3.5658937376879444`*^9, 3.5658938703661776`*^9}, 
   3.5660574760957985`*^9, 3.566567857150896*^9}],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{{3.5657357413298254`*^9, 3.565735784869502*^9}, {
   3.565736079382419*^9, 3.565736233887181*^9}, {3.565736295782721*^9, 
   3.5657363666097717`*^9}, 3.56574168711257*^9, 3.5657428673540525`*^9, 
   3.565743254484333*^9, 3.565743633081398*^9, 3.565786683006219*^9, {
   3.565786764251161*^9, 3.565786834264084*^9}, 3.5657875757333865`*^9, 
   3.565788037884198*^9, {3.565831798117626*^9, 3.5658319296258574`*^9}, 
   3.565893679749443*^9, {3.5658937376879444`*^9, 3.5658938703661776`*^9}, 
   3.5660574760957985`*^9, 3.5665678571976957`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.3702747744241853`", ",", "0.999999877261286`"}], "}"}]], "Output",
 CellChangeTimes->{{3.5657357413298254`*^9, 3.565735784869502*^9}, {
   3.565736079382419*^9, 3.565736233887181*^9}, {3.565736295782721*^9, 
   3.5657363666097717`*^9}, 3.56574168711257*^9, 3.5657428673540525`*^9, 
   3.565743254484333*^9, 3.565743633081398*^9, 3.565786683006219*^9, {
   3.565786764251161*^9, 3.565786834264084*^9}, 3.5657875757333865`*^9, 
   3.565788037884198*^9, {3.565831798117626*^9, 3.5658319296258574`*^9}, 
   3.565893679749443*^9, {3.5658937376879444`*^9, 3.5658938703661776`*^9}, 
   3.5660574760957985`*^9, 3.5665678571976957`*^9}],

Cell[BoxData[
 GraphicsBox[{{{}, 
    {Hue[0.67, 0.6, 0.6], PointBox[CompressedData["
1:eJxV2nc41e//B3AtaS+fpiYt2pSmp6I0NJRRKkkZUUJIheyRjCRJshKRJCGp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      "]]}, {}}, {CircleBox[{0, 0}], LineBox[{{0, 0}, {1, 1}}]}},
  Axes->True,
  AxesOrigin->{0.4, 0},
  ImageSize->{586., Automatic},
  PlotRange->{{-0.2, 2.2}, {-0.2, 1.2}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{{3.5657357413298254`*^9, 3.565735784869502*^9}, {
   3.565736079382419*^9, 3.565736233887181*^9}, {3.565736295782721*^9, 
   3.5657363666097717`*^9}, 3.56574168711257*^9, 3.5657428673540525`*^9, 
   3.565743254484333*^9, 3.565743633081398*^9, 3.565786683006219*^9, {
   3.565786764251161*^9, 3.565786834264084*^9}, 3.5657875757333865`*^9, 
   3.565788037884198*^9, {3.565831798117626*^9, 3.5658319296258574`*^9}, 
   3.565893679749443*^9, {3.5658937376879444`*^9, 3.5658938703661776`*^9}, 
   3.5660574760957985`*^9, 3.5665678571976957`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Clear", "[", "B", "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"B", "[", "r_", "]"}], ":=", 
  RowBox[{"Bmodel", "[", "r", "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"R0", "=", "1.157632"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"t", "=", 
   RowBox[{"trajectory", "[", 
    RowBox[{"R0", ",", "2"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"evaltrajectory", "[", "t", "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"path", "=", 
   RowBox[{"Interpolation", "[", 
    RowBox[{"t", "[", 
     RowBox[{"[", 
      RowBox[{";;", "20"}], "]"}], "]"}], " ", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Block", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"p", "=", 
     RowBox[{"Quiet", "[", 
      RowBox[{"path", "[", 
       RowBox[{"Pi", "/", "4"}], "]"}], "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"p", "[", 
      RowBox[{"[", "1", "]"}], "]"}], ",", 
     RowBox[{
      RowBox[{"p", "[", 
       RowBox[{"[", "1", "]"}], "]"}], "/", 
      RowBox[{"p", "[", 
       RowBox[{"[", "2", "]"}], "]"}]}]}], " ", "}"}]}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"plottrajectory", "[", "t", "]"}]}], "Input",
 CellChangeTimes->{{3.5356586586103277`*^9, 3.5356586849328337`*^9}, {
  3.565731541022448*^9, 3.5657315516148663`*^9}, {3.565732563089443*^9, 
  3.565732568206252*^9}, {3.5657326372675734`*^9, 3.565732639373577*^9}, {
  3.5657350912610836`*^9, 3.565735092087885*^9}, {3.565735159932404*^9, 
  3.565735161539207*^9}, {3.5657352290405254`*^9, 3.56573523719934*^9}, {
  3.5657352976338463`*^9, 3.565735298694648*^9}, {3.5657354126528482`*^9, 
  3.5657354131988487`*^9}, {3.565735557701903*^9, 3.565735559074705*^9}, {
  3.565735708054967*^9, 3.5657357288810034`*^9}, {3.5657357608766594`*^9, 
  3.565735783293899*^9}, {3.5657360762000136`*^9, 3.56573623282712*^9}, {
  3.5657362934505873`*^9, 3.565736364333642*^9}, {3.56574323003909*^9, 
  3.5657432500539255`*^9}, {3.565786761786357*^9, 3.565786832891282*^9}, {
  3.565831810051647*^9, 3.5658319281750546`*^9}, {3.5660574976082363`*^9, 
  3.566057655792514*^9}}],

Cell[BoxData["1.157632`"], "Output",
 CellChangeTimes->{{3.5657357413298254`*^9, 3.565735784869502*^9}, {
   3.565736079382419*^9, 3.565736233887181*^9}, {3.565736295782721*^9, 
   3.5657363666097717`*^9}, 3.56574168711257*^9, 3.5657428673540525`*^9, 
   3.565743254484333*^9, 3.565743633081398*^9, 3.565786683006219*^9, {
   3.565786764251161*^9, 3.565786834264084*^9}, 3.5657875757333865`*^9, 
   3.565788037884198*^9, {3.565831798117626*^9, 3.5658319296258574`*^9}, 
   3.565893679749443*^9, 3.5658938856230044`*^9, {3.5660574762517986`*^9, 
   3.5660576566973157`*^9}, 3.566567857228896*^9}],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{{3.5657357413298254`*^9, 3.565735784869502*^9}, {
   3.565736079382419*^9, 3.565736233887181*^9}, {3.565736295782721*^9, 
   3.5657363666097717`*^9}, 3.56574168711257*^9, 3.5657428673540525`*^9, 
   3.565743254484333*^9, 3.565743633081398*^9, 3.565786683006219*^9, {
   3.565786764251161*^9, 3.565786834264084*^9}, 3.5657875757333865`*^9, 
   3.565788037884198*^9, {3.565831798117626*^9, 3.5658319296258574`*^9}, 
   3.565893679749443*^9, 3.5658938856230044`*^9, {3.5660574762517986`*^9, 
   3.5660576566973157`*^9}, 3.5665678572600965`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.3754835662392492`", ",", "1.0000013067077405`"}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.5657357413298254`*^9, 3.565735784869502*^9}, {
   3.565736079382419*^9, 3.565736233887181*^9}, {3.565736295782721*^9, 
   3.5657363666097717`*^9}, 3.56574168711257*^9, 3.5657428673540525`*^9, 
   3.565743254484333*^9, 3.565743633081398*^9, 3.565786683006219*^9, {
   3.565786764251161*^9, 3.565786834264084*^9}, 3.5657875757333865`*^9, 
   3.565788037884198*^9, {3.565831798117626*^9, 3.5658319296258574`*^9}, 
   3.565893679749443*^9, 3.5658938856230044`*^9, {3.5660574762517986`*^9, 
   3.5660576566973157`*^9}, 3.5665678572756963`*^9}],

Cell[BoxData[
 GraphicsBox[{{{}, 
    {Hue[0.67, 0.6, 0.6], PointBox[CompressedData["
1:eJxV2nc81e/7B3BJpULER5RKojSVppSXlpRSSSUpkoiQUIRKkk1mS9mbipJV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      "]]}, {}}, {CircleBox[{0, 0}], LineBox[{{0, 0}, {1, 1}}]}},
  Axes->True,
  AxesOrigin->{0.4, 0},
  ImageSize->{586., Automatic},
  PlotRange->{{-0.2, 2.2}, {-0.2, 1.2}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{{3.5657357413298254`*^9, 3.565735784869502*^9}, {
   3.565736079382419*^9, 3.565736233887181*^9}, {3.565736295782721*^9, 
   3.5657363666097717`*^9}, 3.56574168711257*^9, 3.5657428673540525`*^9, 
   3.565743254484333*^9, 3.565743633081398*^9, 3.565786683006219*^9, {
   3.565786764251161*^9, 3.565786834264084*^9}, 3.5657875757333865`*^9, 
   3.565788037884198*^9, {3.565831798117626*^9, 3.5658319296258574`*^9}, 
   3.565893679749443*^9, 3.5658938856230044`*^9, {3.5660574762517986`*^9, 
   3.5660576566973157`*^9}, 3.5665678572756963`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
R0 = 1.157632 is the ratio of required cyclotron radius when B = 1 to \
pole-piece radius. Pole piece R = 2.5 inch. R0 in cm:\
\>", "Subsection",
 CellChangeTimes->{{3.5657364898100038`*^9, 3.5657365612113295`*^9}, {
   3.5657368181281805`*^9, 3.5657368569878488`*^9}, 3.565831946115086*^9, {
   3.566057680393757*^9, 3.566057688084571*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"1.158", " ", "2.5", " ", "2.54"}]], "Input",
 CellChangeTimes->{{3.565736249874095*^9, 3.5657362811738853`*^9}, {
   3.565736373507167*^9, 3.565736374403218*^9}, {3.5658319540243*^9, 
   3.5658319581739073`*^9}, 3.566057708239806*^9, {3.566057792381962*^9, 
   3.566057794285165*^9}}],

Cell[BoxData["7.353299999999999`"], "Output",
 CellChangeTimes->{{3.565736265049963*^9, 3.565736282599967*^9}, 
   3.5657363758803024`*^9, 3.5657416871715727`*^9, 3.565786683068619*^9, 
   3.565787575811387*^9, 3.5657880379621983`*^9, 3.56583195981191*^9, 
   3.5658936798586426`*^9, 3.5660574763297987`*^9, {3.566057692858179*^9, 
   3.5660577100494094`*^9}, 3.566057796141568*^9, 3.566567857291296*^9}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Calculate offset trajectories, show focussing\
\>", "Section",
 CellChangeTimes->{{3.5657317742272577`*^9, 3.5657318237261443`*^9}, {
  3.565732724300126*^9, 3.5657327353761454`*^9}, {3.5657417776187468`*^9, 
  3.5657417849461517`*^9}, {3.565746046577237*^9, 3.5657460520528464`*^9}}],

Cell[CellGroupData[{

Cell["\<\
Resulting trajectory (list of points as in function step[ ]). Stops when \
trajectory crosses y-axis outside magnet.\
\>", "Subsection",
 CellChangeTimes->{{3.5657318767818375`*^9, 3.565731945858759*^9}, 
   3.565731987526432*^9, {3.565732798821457*^9, 3.565732858943963*^9}, {
   3.565732947879719*^9, 3.565732949283721*^9}, {3.56573304539549*^9, 
   3.565733106734798*^9}, {3.565733143972063*^9, 3.565733206871374*^9}, {
   3.565733254357857*^9, 3.5657332713150873`*^9}, {3.565741808112192*^9, 
   3.565741828220628*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"trajectory", "[", 
   RowBox[{"R0_", ",", "x0_", ",", "y0_", ",", "\[Theta]0_"}], "]"}], ":=", 
  "\[IndentingNewLine]", 
  RowBox[{"Block", "[", 
   RowBox[{
    RowBox[{"{", " ", 
     RowBox[{"points", "=", 
      RowBox[{"{", 
       RowBox[{"{", 
        RowBox[{"\[Theta]0", ",", 
         RowBox[{"{", 
          RowBox[{"x0", ",", "y0"}], "}"}]}], "}"}], "}"}]}], " ", "}"}], ",",
     "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"NestWhile", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{"Block", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"pt", "=", 
            RowBox[{"step", "[", 
             RowBox[{"#", ",", "R0"}], "]"}]}], "}"}], ",", 
          RowBox[{
           RowBox[{"PrependTo", "[", 
            RowBox[{"points", ",", "pt"}], "]"}], ";", "pt"}]}], "]"}], "&"}],
        ",", "\[IndentingNewLine]", 
       RowBox[{"points", "[", 
        RowBox[{"[", "1", "]"}], "]"}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"!", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"#", "[", 
             RowBox[{"[", 
              RowBox[{"2", ",", "2"}], "]"}], "]"}], ">", 
            RowBox[{"1.02", "R0", 
             RowBox[{"(", 
              RowBox[{"1", "+", 
               RowBox[{"R0", "/", 
                RowBox[{"(", 
                 RowBox[{"x0", "-", "R0"}], ")"}]}]}], ")"}]}]}], ")"}]}], 
         ")"}], "&"}]}], "\[IndentingNewLine]", "]"}], ";", 
     "\[IndentingNewLine]", "points"}]}], "\[IndentingNewLine]", 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.535659636746274*^9, 3.535659641321536*^9}, {
   3.535659737784053*^9, 3.535659741503266*^9}, {3.5356599246547413`*^9, 
   3.535659953804409*^9}, {3.5356599871173143`*^9, 3.535660064996769*^9}, {
   3.5356601373369064`*^9, 3.53566018478262*^9}, {3.535660217037465*^9, 
   3.535660226826025*^9}, {3.535660358137535*^9, 3.535660367121049*^9}, {
   3.5356611518229313`*^9, 3.5356611571102343`*^9}, {3.5356612497895346`*^9, 
   3.5356612546948156`*^9}, {3.5356617109629126`*^9, 3.535661737405425*^9}, {
   3.535661778720788*^9, 3.535661782329994*^9}, 3.5657332284306116`*^9, {
   3.565733289364319*^9, 3.565733425646158*^9}, {3.565733458733816*^9, 
   3.5657334717286386`*^9}, {3.565733927187039*^9, 3.5657339298390436`*^9}, {
   3.56573420673953*^9, 3.5657342142587433`*^9}, {3.565741843321454*^9, 
   3.565741855848276*^9}, {3.5657419186227865`*^9, 3.565741921181191*^9}, {
   3.5657429439813876`*^9, 3.5657429492073965`*^9}, {3.565743038127553*^9, 
   3.565743046036767*^9}, {3.5657431129764843`*^9, 3.56574311647089*^9}, {
   3.5657432986480103`*^9, 3.565743301346815*^9}, {3.5657434581738906`*^9, 
   3.565743481371131*^9}, {3.5657444520516367`*^9, 3.565744457137245*^9}, {
   3.565745242130624*^9, 3.565745250242638*^9}, {3.5657453385543933`*^9, 
   3.5657453998937016`*^9}, {3.5657454848358502`*^9, 3.5657454859902525`*^9}}],

Cell[BoxData[{
 RowBox[{"Clear", "[", "B", "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"B", "[", "r_", "]"}], ":=", 
  RowBox[{"Bmodel", "[", "r", "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"t1", "=", 
   RowBox[{"trajectory", "[", 
    RowBox[{"R0", ",", 
     RowBox[{"R0", " ", "2"}], ",", "0", ",", "0.02"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"t2", "=", 
   RowBox[{"trajectory", "[", 
    RowBox[{"R0", ",", 
     RowBox[{"R0", " ", "2"}], ",", "0", ",", 
     RowBox[{"-", "0.02"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"p1", "=", 
   RowBox[{"Show", "[", 
    RowBox[{
     RowBox[{"plottrajectory", "[", 
      RowBox[{"t1", ",", "R0", ",", 
       RowBox[{"Joined", "\[Rule]", "True"}], ",", 
       RowBox[{"PlotStyle", "\[Rule]", "Thick"}]}], "]"}], ",", 
     RowBox[{"plottrajectory", "[", 
      RowBox[{"t2", ",", "R0", ",", 
       RowBox[{"Joined", "\[Rule]", "True"}], ",", 
       RowBox[{"PlotStyle", "\[Rule]", "Thick"}]}], "]"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.5657431873106146`*^9, 3.5657432060150476`*^9}, {
   3.5657432634543486`*^9, 3.5657432673387556`*^9}, {3.5657433363688765`*^9, 
   3.5657433866009645`*^9}, {3.5657434970803585`*^9, 
   3.5657435190919976`*^9}, {3.5657435534432583`*^9, 
   3.5657436094317565`*^9}, {3.5657438943662567`*^9, 3.565743935534729*^9}, {
   3.565744284912943*^9, 3.565744341010641*^9}, {3.5657443798547096`*^9, 
   3.565744422895185*^9}, {3.565744479804085*^9, 3.565744525933366*^9}, {
   3.5657445563066196`*^9, 3.5657445814070635`*^9}, {3.5657446149471226`*^9, 
   3.56574461922153*^9}, {3.5657446555851936`*^9, 3.5657446729948244`*^9}, {
   3.565744713242895*^9, 3.5657447168777013`*^9}, {3.565744756361371*^9, 
   3.565744759060176*^9}, {3.5657454497045884`*^9, 3.5657454530741944`*^9}, {
   3.5657456397753224`*^9, 3.5657456529573455`*^9}, {3.5657458749769354`*^9, 
   3.5657458908889637`*^9}, {3.5657459392958484`*^9, 
   3.5657459421974535`*^9}, {3.565745981915123*^9, 3.5657459867979317`*^9}, {
   3.5657869409682713`*^9, 3.5657869705459237`*^9}, 3.5657876546227255`*^9, {
   3.5657879524584484`*^9, 3.56578795913526*^9}, 3.565788384111206*^9, {
   3.5657885765063443`*^9, 3.5657885928239727`*^9}, {3.565790828800386*^9, 
   3.565790832558601*^9}}],

Cell[BoxData[{
 RowBox[{"Clear", "[", "B", "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"B", "[", "r_", "]"}], ":=", 
  RowBox[{
   RowBox[{"Bconstant", "[", "R0", "]"}], "[", "r", 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"t3", "=", 
   RowBox[{"trajectory", "[", 
    RowBox[{"R0", ",", 
     RowBox[{"R0", " ", "2"}], ",", "0", ",", "0.02"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"t4", "=", 
   RowBox[{"trajectory", "[", 
    RowBox[{"R0", ",", 
     RowBox[{"R0", " ", "2"}], ",", "0", ",", 
     RowBox[{"-", "0.02"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"p2", "=", 
   RowBox[{"Show", "[", 
    RowBox[{
     RowBox[{"plottrajectory", "[", 
      RowBox[{"t3", ",", "R0", ",", 
       RowBox[{"Joined", "\[Rule]", "True"}], ",", 
       RowBox[{"PlotStyle", "\[Rule]", 
        RowBox[{"Darker", "[", 
         RowBox[{"Green", ",", ".7"}], "]"}]}]}], "]"}], ",", 
     RowBox[{"plottrajectory", "[", 
      RowBox[{"t4", ",", "R0", ",", 
       RowBox[{"Joined", "\[Rule]", "True"}], ",", 
       RowBox[{"PlotStyle", "\[Rule]", 
        RowBox[{"Darker", "[", 
         RowBox[{"Green", ",", ".7"}], "]"}]}]}], "]"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.5657431873106146`*^9, 3.5657432060150476`*^9}, {
   3.5657432634543486`*^9, 3.5657432673387556`*^9}, {3.5657433363688765`*^9, 
   3.5657433866009645`*^9}, {3.5657434970803585`*^9, 
   3.5657435190919976`*^9}, {3.5657435534432583`*^9, 
   3.5657436094317565`*^9}, {3.5657438943662567`*^9, 3.565743935534729*^9}, {
   3.565744284912943*^9, 3.565744341010641*^9}, {3.5657443798547096`*^9, 
   3.565744422895185*^9}, {3.565744479804085*^9, 3.565744525933366*^9}, {
   3.5657445563066196`*^9, 3.5657445814070635`*^9}, {3.5657446149471226`*^9, 
   3.56574461922153*^9}, {3.5657446555851936`*^9, 3.5657446729948244`*^9}, {
   3.565744713242895*^9, 3.5657447168777013`*^9}, {3.565744756361371*^9, 
   3.565744759060176*^9}, {3.5657454497045884`*^9, 3.5657454530741944`*^9}, {
   3.5657456397753224`*^9, 3.5657456529573455`*^9}, {3.5657458749769354`*^9, 
   3.5657458908889637`*^9}, {3.5657459392958484`*^9, 
   3.5657459421974535`*^9}, {3.565745981915123*^9, 3.5657459867979317`*^9}, {
   3.5657869409682713`*^9, 3.5657869705459237`*^9}, {3.565787011168395*^9, 
   3.565787068326895*^9}, {3.5657876749027605`*^9, 3.565787678958768*^9}, {
   3.5657878808231225`*^9, 3.565787886969533*^9}, {3.565787968276876*^9, 
   3.5657880006937327`*^9}, 3.5657883889940147`*^9, {3.565788532873068*^9, 
   3.5657885377870765`*^9}, {3.5657886176124163`*^9, 3.565788632557243*^9}, {
   3.5657886701377087`*^9, 3.5657886740689154`*^9}, {3.565788723786203*^9, 
   3.565788760290267*^9}, {3.565790838779957*^9, 3.5657908423451605`*^9}}],

Cell[BoxData[{
 RowBox[{"Clear", "[", "B", "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"B", "[", "r_", "]"}], ":=", 
  RowBox[{
   RowBox[{"Bconstant", "[", "1.0", "]"}], "[", "r", 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"t5", "=", 
   RowBox[{"trajectory", "[", 
    RowBox[{"R0", ",", 
     RowBox[{"R0", " ", "2"}], ",", "0", ",", "0.02"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"t6", "=", 
   RowBox[{"trajectory", "[", 
    RowBox[{"R0", ",", 
     RowBox[{"R0", " ", "2"}], ",", "0", ",", 
     RowBox[{"-", "0.02"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"p3", "=", 
   RowBox[{"Show", "[", 
    RowBox[{
     RowBox[{"plottrajectory", "[", 
      RowBox[{"t5", ",", "R0", ",", 
       RowBox[{"Joined", "\[Rule]", "True"}], ",", 
       RowBox[{"PlotStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"Dashed", ",", "Red"}], "}"}]}]}], "]"}], ",", 
     RowBox[{"plottrajectory", "[", 
      RowBox[{"t6", ",", "R0", ",", 
       RowBox[{"Joined", "\[Rule]", "True"}], ",", 
       RowBox[{"PlotStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"Dashed", ",", "Red"}], "}"}]}]}], "]"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.5657431873106146`*^9, 3.5657432060150476`*^9}, {
   3.5657432634543486`*^9, 3.5657432673387556`*^9}, {3.5657433363688765`*^9, 
   3.5657433866009645`*^9}, {3.5657434970803585`*^9, 
   3.5657435190919976`*^9}, {3.5657435534432583`*^9, 
   3.5657436094317565`*^9}, {3.5657438943662567`*^9, 3.565743935534729*^9}, {
   3.565744284912943*^9, 3.565744341010641*^9}, {3.5657443798547096`*^9, 
   3.565744422895185*^9}, {3.565744479804085*^9, 3.565744525933366*^9}, {
   3.5657445563066196`*^9, 3.5657445814070635`*^9}, {3.5657446149471226`*^9, 
   3.56574461922153*^9}, {3.5657446555851936`*^9, 3.5657446729948244`*^9}, {
   3.565744713242895*^9, 3.5657447168777013`*^9}, {3.565744756361371*^9, 
   3.565744759060176*^9}, {3.5657454497045884`*^9, 3.5657454530741944`*^9}, {
   3.5657456397753224`*^9, 3.5657456529573455`*^9}, {3.5657458749769354`*^9, 
   3.5657458908889637`*^9}, {3.5657459392958484`*^9, 
   3.5657459421974535`*^9}, {3.565745981915123*^9, 3.5657459867979317`*^9}, {
   3.5657869409682713`*^9, 3.5657869705459237`*^9}, {3.565787011168395*^9, 
   3.565787068326895*^9}, {3.5657876749027605`*^9, 3.565787678958768*^9}, {
   3.5657878808231225`*^9, 3.565787886969533*^9}, {3.565787968276876*^9, 
   3.5657880006937327`*^9}, 3.5657883889940147`*^9, {3.5657884437657113`*^9, 
   3.565788497195805*^9}, {3.565790846550401*^9, 3.565790849385563*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{"p1", ",", "p2", ",", "p3", ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", ".5"}], ",", "2.5"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", ".3"}], ",", "2.5"}], "}"}]}], "}"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.565787078404513*^9, 3.565787085050125*^9}, {
   3.5657871322090073`*^9, 3.565787172535078*^9}, {3.5657883148626847`*^9, 
   3.565788320541095*^9}, {3.5657884993954086`*^9, 3.565788500627811*^9}, {
   3.565788795655529*^9, 3.565788810225955*^9}, {3.565788841004809*^9, 
   3.5657888525644293`*^9}, 3.565788884872086*^9}],

Cell[BoxData[
 GraphicsBox[{{{{{}, {}, 
      {Hue[0.67, 0.6, 0.6], Thickness[Large], LineBox[CompressedData["
1:eJwc13VYFU0UB+DLFRVQsQsLu1DBwgB+q4iBhYhYiKiIioiIdEmXdCMdAgLS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        "]]}}, {CircleBox[{0, 0}], 
      {Dashing[{Small, Small}], CircleBox[{0, 0}, 1.157632]}}}, {{{}, {}, 
      {Hue[0.67, 0.6, 0.6], Thickness[Large], LineBox[CompressedData["
1:eJwc13c81V8YB/B7EU1FJU1RkSRJktXni0pLCmkLicoMGakkIUmIUiFEUklI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        "]]}}, {CircleBox[{0, 0}], 
      {Dashing[{Small, Small}], CircleBox[{0, 0}, 1.157632]}}}}, {{{{}, {}, 
      {RGBColor[0., 0.30000000000000004`, 0.], LineBox[CompressedData["
1:eJwc13c4lW8YB/DjVEpJS0uihGhKu9T3JZGmpGiJlKKSzIa9954JDSsiaSF7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        "]]}}, {CircleBox[{0, 0}], 
      {Dashing[{Small, Small}], CircleBox[{0, 0}, 1.157632]}}}, {{{}, {}, 
      {RGBColor[0., 0.30000000000000004`, 0.], LineBox[CompressedData["
1:eJwc12VUVU0UBuB7L6GiIoKCYoOADYiFiPuYhEVId4jSIhKS0iXdYKGUCBIi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        "]]}}, {CircleBox[{0, 0}], 
      {Dashing[{Small, Small}], CircleBox[{0, 0}, 1.157632]}}}}, {{{{}, {}, 
      {RGBColor[1, 0, 0], Dashing[{Small, Small}], LineBox[CompressedData["
1:eJwc13dYz98XAPDP5yMJSSIrJBWSUFYpzjsjoxBCCElIIqHISpSERERS2jtK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        "]]}}, {CircleBox[{0, 0}], 
      {Dashing[{Small, Small}], CircleBox[{0, 0}, 1.157632]}}}, {{{}, {}, 
      {RGBColor[1, 0, 0], Dashing[{Small, Small}], LineBox[CompressedData["
1:eJwc1ndcTu8bB/DneUKDpIyEJKmIkKhkXEeEzGSEjMqWlUgilBFRRkQpGpSG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        "]]}}, {CircleBox[{0, 0}], 
      {Dashing[{Small, Small}], CircleBox[{0, 0}, 1.157632]}}}}},
  Axes->True,
  AxesOrigin->{0, 0},
  ImageSize->{509., Automatic},
  PlotRange->{{-0.5, 2.5}, {-0.3, 2.5}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{
  3.565787085689726*^9, 3.565787140898223*^9, 3.56578717333068*^9, 
   3.565788038320999*^9, {3.565788302663463*^9, 3.565788321258696*^9}, 
   3.565788392504021*^9, 3.5657885059942207`*^9, 3.565788542342284*^9, 
   3.565788600358786*^9, {3.565788637128051*^9, 3.565788681026528*^9}, {
   3.565788735704624*^9, 3.5657887662494774`*^9}, 3.565788855684435*^9, 
   3.5657888863540883`*^9, 3.5657908547178683`*^9, 3.5658319969555755`*^9, 
   3.566057900895752*^9, 3.5665678581180973`*^9}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Show how mass resolution is achieved\
\>", "Section",
 CellChangeTimes->{{3.5657317742272577`*^9, 3.5657318237261443`*^9}, {
  3.565732724300126*^9, 3.5657327353761454`*^9}, {3.5657417776187468`*^9, 
  3.5657417849461517`*^9}, {3.565746046577237*^9, 3.5657460520528464`*^9}, {
  3.566567912468593*^9, 3.566567968004691*^9}}],

Cell[CellGroupData[{

Cell[TextData[{
 "The selected isotope has a cyclotron radius = R0. The radius goes as ",
 Cell[BoxData[
  FormBox[
   SqrtBox["m"], TraditionalForm]],
  FormatType->"TraditionalForm"],
 " for fixed B and V."
}], "Subsection",
 CellChangeTimes->{{3.5657318767818375`*^9, 3.565731945858759*^9}, 
   3.565731987526432*^9, {3.565732798821457*^9, 3.565732858943963*^9}, {
   3.565732947879719*^9, 3.565732949283721*^9}, {3.56573304539549*^9, 
   3.565733106734798*^9}, {3.565733143972063*^9, 3.565733206871374*^9}, {
   3.565733254357857*^9, 3.5657332713150873`*^9}, {3.565741808112192*^9, 
   3.565741828220628*^9}, {3.566568133084181*^9, 3.5665682531263914`*^9}}],

Cell[BoxData[{
 RowBox[{"Clear", "[", "B", "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"B", "[", "r_", "]"}], ":=", 
  RowBox[{"Bmodel", "[", "r", "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"t7", "=", 
   RowBox[{"trajectory", "[", 
    RowBox[{"R0", ",", 
     RowBox[{"R0", " ", "2"}], ",", "0", ",", "0"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"t8", "=", 
   RowBox[{"trajectory", "[", 
    RowBox[{
     RowBox[{"R0", 
      SqrtBox["1.05"]}], ",", 
     RowBox[{"R0", " ", "2"}], ",", "0", ",", "0"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"t9", "=", 
   RowBox[{"trajectory", "[", 
    RowBox[{
     RowBox[{"R0", 
      SqrtBox[".95"]}], ",", 
     RowBox[{"R0", " ", "2"}], ",", "0", ",", "0"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"p4", "=", 
   RowBox[{"Show", "[", 
    RowBox[{
     RowBox[{"plottrajectory", "[", 
      RowBox[{"t7", ",", "R0", ",", 
       RowBox[{"Joined", "\[Rule]", "True"}], ",", 
       RowBox[{"PlotStyle", "\[Rule]", "Thick"}]}], "]"}], ",", 
     RowBox[{"plottrajectory", "[", 
      RowBox[{"t8", ",", "R0", ",", 
       RowBox[{"Joined", "\[Rule]", "True"}], ",", 
       RowBox[{"PlotStyle", "\[Rule]", "Thick"}]}], "]"}], ",", 
     RowBox[{"plottrajectory", "[", 
      RowBox[{"t9", ",", "R0", ",", 
       RowBox[{"Joined", "\[Rule]", "True"}], ",", 
       RowBox[{"PlotStyle", "\[Rule]", "Thick"}]}], "]"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.5657431873106146`*^9, 3.5657432060150476`*^9}, {
   3.5657432634543486`*^9, 3.5657432673387556`*^9}, {3.5657433363688765`*^9, 
   3.5657433866009645`*^9}, {3.5657434970803585`*^9, 
   3.5657435190919976`*^9}, {3.5657435534432583`*^9, 
   3.5657436094317565`*^9}, {3.5657438943662567`*^9, 3.565743935534729*^9}, {
   3.565744284912943*^9, 3.565744341010641*^9}, {3.5657443798547096`*^9, 
   3.565744422895185*^9}, {3.565744479804085*^9, 3.565744525933366*^9}, {
   3.5657445563066196`*^9, 3.5657445814070635`*^9}, {3.5657446149471226`*^9, 
   3.56574461922153*^9}, {3.5657446555851936`*^9, 3.5657446729948244`*^9}, {
   3.565744713242895*^9, 3.5657447168777013`*^9}, {3.565744756361371*^9, 
   3.565744759060176*^9}, {3.5657454497045884`*^9, 3.5657454530741944`*^9}, {
   3.5657456397753224`*^9, 3.5657456529573455`*^9}, {3.5657458749769354`*^9, 
   3.5657458908889637`*^9}, {3.5657459392958484`*^9, 
   3.5657459421974535`*^9}, {3.565745981915123*^9, 3.5657459867979317`*^9}, {
   3.5657869409682713`*^9, 3.5657869705459237`*^9}, 3.5657876546227255`*^9, {
   3.5657879524584484`*^9, 3.56578795913526*^9}, 3.565788384111206*^9, {
   3.5657885765063443`*^9, 3.5657885928239727`*^9}, {3.565790828800386*^9, 
   3.565790832558601*^9}, {3.566568349784161*^9, 3.566568365321789*^9}, {
   3.5665684011394515`*^9, 3.566568503631632*^9}, {3.5665685649085393`*^9, 
   3.566568569026946*^9}, {3.5665690005221043`*^9, 3.566569004812112*^9}, {
   3.566569083919851*^9, 3.566569111422699*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{"p4", ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", ".5"}], ",", "2.5"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", ".3"}], ",", "2.5"}], "}"}]}], "}"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.565787078404513*^9, 3.565787085050125*^9}, {
   3.5657871322090073`*^9, 3.565787172535078*^9}, {3.5657883148626847`*^9, 
   3.565788320541095*^9}, {3.5657884993954086`*^9, 3.565788500627811*^9}, {
   3.565788795655529*^9, 3.565788810225955*^9}, {3.565788841004809*^9, 
   3.5657888525644293`*^9}, 3.565788884872086*^9, {3.5665684203586855`*^9, 
   3.5665684206550856`*^9}}],

Cell[BoxData[
 GraphicsBox[{{{{}, {}, 
     {Hue[0.67, 0.6, 0.6], Thickness[Large], LineBox[CompressedData["
1:eJwc13c81d8fB/B7b6VS36aQNCRJkiRJqtentDWkkkolqYQkXTtkJySEENlJ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       "]]}}, {CircleBox[{0, 0}], 
     {Dashing[{Small, Small}], CircleBox[{0, 0}, 1.157632]}}}, {{{}, {}, 
     {Hue[0.67, 0.6, 0.6], Thickness[Large], LineBox[CompressedData["
1:eJwc13dczV8YB/DbbZlZ2SsSEhKShM+XkD1DZkYJDSPzR1JJqLRV2uve25BU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       "]]}}, {CircleBox[{0, 0}], 
     {Dashing[{Small, Small}], CircleBox[{0, 0}, 1.157632]}}}, {{{}, {}, 
     {Hue[0.67, 0.6, 0.6], Thickness[Large], LineBox[CompressedData["
1:eJwc13dczd8fB/AbIqMUIhEaVhEVKuJ1JYlIGsoo8VWSUVqUSIUIWSEJqaTu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       "]]}}, {CircleBox[{0, 0}], 
     {Dashing[{Small, Small}], CircleBox[{0, 0}, 1.157632]}}}},
  Axes->True,
  AxesOrigin->{0, 0},
  ImageSize->{509., Automatic},
  PlotRange->{{-0.5, 2.5}, {-0.3, 2.5}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{
  3.565787085689726*^9, 3.565787140898223*^9, 3.56578717333068*^9, 
   3.565788038320999*^9, {3.565788302663463*^9, 3.565788321258696*^9}, 
   3.565788392504021*^9, 3.5657885059942207`*^9, 3.565788542342284*^9, 
   3.565788600358786*^9, {3.565788637128051*^9, 3.565788681026528*^9}, {
   3.565788735704624*^9, 3.5657887662494774`*^9}, 3.565788855684435*^9, 
   3.5657888863540883`*^9, 3.5657908547178683`*^9, 3.5658319969555755`*^9, 
   3.566057900895752*^9, 3.5665678581180973`*^9, 3.56656851409925*^9, 
   3.566568573379354*^9, 3.566569013017726*^9, {3.5665690902846622`*^9, 
   3.5665691149951057`*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"Beam", " ", "displacement", " ", 
     RowBox[{"(", 
      RowBox[{"in", " ", "units", " ", "of", " ", "R0"}], ")"}], " ", "for", 
     " ", "the", " ", "changes", " ", "in", " ", 
     RowBox[{"mass", ".", " ", "This"}], " ", "must", " ", "be"}], " ", ">", 
    " ", 
    RowBox[{"2", "\[Times]", 
     RowBox[{"(", 
      RowBox[{"slit", " ", "width"}], ")"}], " ", "for", " ", "the", " ", 
     "mass", " ", "changes", " ", "to", " ", "be", " ", 
     RowBox[{"resolved", "."}]}]}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"beam", "=", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"t7", "//", "First"}], "//", "Last"}], "//", "First"}], 
       ")"}], "/", "R0"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"t8", "//", "First"}], "//", "Last"}], "//", "First"}], ")"}],
      "/", "R0"}], "-", "beam"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"t9", "//", "First"}], "//", "Last"}], "//", "First"}], ")"}],
      "/", "R0"}], "-", "beam"}]}]}]], "Input",
 CellChangeTimes->{{3.5665686037682076`*^9, 3.566568607465414*^9}, {
   3.566568663280712*^9, 3.5665686942779665`*^9}, {3.5665689339723873`*^9, 
   3.5665689438004045`*^9}, {3.566568974298458*^9, 3.5665689877300816`*^9}, {
   3.566569048304988*^9, 3.566569058413806*^9}, 3.566569240700126*^9, {
   3.5665692729765825`*^9, 3.5665694376972723`*^9}}],

Cell[BoxData[
 RowBox[{"-", "0.047183562583028915`"}]], "Output",
 CellChangeTimes->{
  3.566568608089415*^9, {3.5665686744347315`*^9, 3.5665686953699684`*^9}, 
   3.566568944954807*^9, {3.566568988260483*^9, 3.566569013033326*^9}, {
   3.5665690604262094`*^9, 3.566569115026305*^9}, 3.5665692420261283`*^9}],

Cell[BoxData["0.04505132475267364`"], "Output",
 CellChangeTimes->{
  3.566568608089415*^9, {3.5665686744347315`*^9, 3.5665686953699684`*^9}, 
   3.566568944954807*^9, {3.566568988260483*^9, 3.566569013033326*^9}, {
   3.5665690604262094`*^9, 3.566569115026305*^9}, 3.5665692420261283`*^9}]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
WindowSize->{850, 750},
WindowMargins->{{51, Automatic}, {Automatic, 60}},
FrontEndVersion->"8.0 for Microsoft Windows (64-bit) (February 23, 2011)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[567, 22, 162, 3, 137, "Title"],
Cell[CellGroupData[{
Cell[754, 29, 140, 2, 71, "Section"],
Cell[CellGroupData[{
Cell[919, 35, 165, 3, 36, "Subsection"],
Cell[1087, 40, 459, 12, 52, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[1583, 57, 198, 4, 36, "Subsection"],
Cell[1784, 63, 2699, 65, 292, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[4520, 133, 146, 3, 36, "Subsection"],
Cell[CellGroupData[{
Cell[4691, 140, 460, 11, 52, "Input"],
Cell[5154, 153, 189, 4, 30, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[5380, 162, 616, 14, 52, "Input"],
Cell[5999, 178, 471, 12, 30, "Output"]
}, Open  ]],
Cell[6485, 193, 1031, 23, 52, "Input"],
Cell[CellGroupData[{
Cell[7541, 220, 486, 11, 31, "Input"],
Cell[8030, 233, 32140, 583, 242, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[40219, 822, 248, 5, 36, "Subsection"],
Cell[40470, 829, 453, 9, 52, "Input"],
Cell[CellGroupData[{
Cell[40948, 842, 289, 7, 31, "Input"],
Cell[41240, 851, 1712, 35, 245, "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[43013, 893, 192, 4, 71, "Section"],
Cell[CellGroupData[{
Cell[43230, 901, 184, 4, 36, "Subsection"],
Cell[43417, 907, 270, 6, 52, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[43724, 918, 257, 6, 53, "Subsection"],
Cell[CellGroupData[{
Cell[44006, 928, 268, 9, 24, "Item"],
Cell[44277, 939, 245, 6, 24, "Item"]
}, Open  ]],
Cell[44537, 948, 4815, 120, 372, "Input"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[49401, 1074, 168, 2, 71, "Section"],
Cell[CellGroupData[{
Cell[49594, 1080, 577, 9, 53, "Subsection"],
Cell[50174, 1091, 2433, 57, 212, "Input"],
Cell[52610, 1150, 1312, 34, 152, "Input"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[53971, 1190, 206, 3, 71, "Section"],
Cell[54180, 1195, 3502, 92, 272, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[57719, 1292, 424, 7, 71, "Section"],
Cell[CellGroupData[{
Cell[58168, 1303, 2103, 48, 172, "Input"],
Cell[60274, 1353, 595, 8, 30, "Output"],
Cell[60872, 1363, 589, 8, 30, "Output"],
Cell[61464, 1373, 669, 10, 30, "Output"],
Cell[62136, 1385, 14613, 244, 357, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[76786, 1634, 2103, 48, 172, "Input"],
Cell[78892, 1684, 595, 8, 30, "Output"],
Cell[79490, 1694, 589, 8, 30, "Output"],
Cell[80082, 1704, 673, 11, 30, "Output"],
Cell[80758, 1717, 14560, 243, 357, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[95355, 1965, 351, 6, 53, "Subsection"],
Cell[CellGroupData[{
Cell[95731, 1975, 308, 5, 31, "Input"],
Cell[96042, 1982, 404, 5, 30, "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[96507, 1994, 294, 5, 71, "Section"],
Cell[CellGroupData[{
Cell[96826, 2003, 533, 9, 53, "Subsection"],
Cell[97362, 2014, 2979, 65, 192, "Input"],
Cell[100344, 2081, 2331, 47, 152, "Input"],
Cell[102678, 2130, 2785, 56, 152, "Input"],
Cell[105466, 2188, 2616, 54, 152, "Input"],
Cell[CellGroupData[{
Cell[108107, 2246, 698, 16, 31, "Input"],
Cell[108808, 2264, 220138, 3615, 490, "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[329007, 5886, 334, 6, 71, "Section"],
Cell[CellGroupData[{
Cell[329366, 5896, 661, 13, 40, "Subsection"],
Cell[330030, 5911, 3008, 64, 208, "Input"],
Cell[CellGroupData[{
Cell[333063, 5979, 730, 17, 31, "Input"],
Cell[333796, 5998, 108605, 1787, 490, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[442438, 7790, 1605, 42, 112, "Input"],
Cell[444046, 7834, 308, 5, 30, "Output"],
Cell[444357, 7841, 290, 4, 30, "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
